<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEpisodesTable extends Migration {

	public function up()
	{
		Schema::create('episodes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->bigInteger('podcast_id')->unsigned();
			$table->string('title');
			$table->text('description');
			$table->integer('order')->unsigned();
			$table->integer('duration')->unsigned();
			$table->string('url');
			$table->string('driver')->default('http');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('episodes');
	}
}