<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->integer('user_id')->unsigned()->index();
			$table->integer('city_id')->unsigned();
			$table->decimal('longitude');
			$table->decimal('latitude');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}