<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProfileTable extends Migration {

	public function up()
	{
		Schema::create('user_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50)->index();
			$table->integer('country_id')->unsigned()->nullable()->index();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('about', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_profile');
	}
}