<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Place extends Eloquent {

	protected $table = 'places';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'user_id', 'city_id', 'longitude', 'latitude');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function city()
	{
		return $this->hasOne('App\Models\City');
	}

	public function country()
	{
		return $this->hasOne('App\Models\Country');
	}

}