<?php

namespace App\Models;

class AccountService extends Eloquent {

	protected $table = 'account_services';
	public $timestamps = true;
	protected $fillable = array('account_id', 'name', 'description');

	public function account()
	{
		return $this->belongsTo('App\Models\Account');
	}

	public function options()
	{
		return $this->hasMany('App\Models\ServiceOption');
	}

	public function extras()
	{
		return $this->hasMany('App\Models\ServiceExtra');
	}

}