<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('productvariants', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('productvariant_attributes', function(Blueprint $table) {
			$table->foreign('productvariant_id')->references('id')->on('productvariants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('productvariant_attributes', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('productvariants', function(Blueprint $table) {
			$table->dropForeign('productvariants_product_id_foreign');
		});
		Schema::table('productvariant_attributes', function(Blueprint $table) {
			$table->dropForeign('productvariant_attributes_productvariant_id_foreign');
		});
		Schema::table('productvariant_attributes', function(Blueprint $table) {
			$table->dropForeign('productvariant_attributes_attribute_id_foreign');
		});
	}
}