<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->text('slug');
			$table->string('sku', 255);
			$table->text('short_description');
			$table->text('description');
			$table->double('price');
			$table->double('compare_price');
			$table->string('barcode', 255);
			$table->integer('quantity');
			$table->integer('minimum_quantity');
			$table->json('tags');
			$table->string('meta_title', 255);
			$table->string('meta_keyword', 255);
			$table->text('meta_description');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}