<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDistributionsTable extends Migration {

	public function up()
	{
		Schema::create('distributions', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->index();
			$table->bigInteger('amount')->default('0');
			$table->bigInteger('nav_id')->unsigned()->index();
			$table->datetime('distributed_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('distributions');
	}
}