<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration {

	public function up()
	{
		Schema::create('activities', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->index();
			$table->bigInteger('user_id')->unsigned();
			$table->boolean('user_action')->default(true);
			$table->text('description')->nullable();
			$table->string('type')->nullable();
			$table->bigInteger('eventable_id')->index();
			$table->string('eventable_type');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('activities');
	}
}