<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name');
			$table->string('middle_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('email');
			$table->string('mobile')->nullable();
			$table->string('password');
			$table->tinyInteger('status')->unsigned()->default('1');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}