<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActionListsTable extends Migration {

	public function up()
	{
		Schema::create('action_lists', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->tinyInteger('type')->unsigned();
			$table->text('data')->nullable();
			$table->tinyInteger('status')->unsigned()->default('1');
		});
	}

	public function down()
	{
		Schema::drop('action_lists');
	}
}