<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDynamicFormFieldsTable extends Migration {

	public function up()
	{
		Schema::create('dynamic_form_fields', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('dynamic_form_id')->unsigned();
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->tinyInteger('type')->unsigned();
			$table->json('data')->nullable();
			$table->nullableMorphs('component');
		});
	}

	public function down()
	{
		Schema::drop('dynamic_form_fields');
	}
}