<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDynamicListsTable extends Migration {

	public function up()
	{
		Schema::create('dynamic_lists', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->text('description_ar');
			$table->string('description_en')->nullable();
			$table->tinyInteger('type')->unsigned();
			$table->json('data')->nullable();
			$table->tinyInteger('status')->unsigned()->default('1');
		});
	}

	public function down()
	{
		Schema::drop('dynamic_lists');
	}
}