<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFileTemplateTable extends Migration {

	public function up()
	{
		Schema::create('file_template', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->text('content_ar');
			$table->text('content_en')->nullable();
			$table->tinyInteger('type')->unsigned()->default('2');
			$table->bigInteger('file_template_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('file_template');
	}
}