<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProcessStepsTable extends Migration {

	public function up()
	{
		Schema::create('process_steps', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('process_id')->unsigned();
			$table->json('process_version')->nullable();
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->integer('order')->unsigned()->nullable();
			$table->nullableMorphs('target');
		});
	}

	public function down()
	{
		Schema::drop('process_steps');
	}
}