<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProcessesTable extends Migration {

	public function up()
	{
		Schema::create('processes', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('serial')->nullable();
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->datetime('version_date')->nullable();
			$table->tinyInteger('status')->unsigned()->default('1');
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('processes');
	}
}