<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReadableLogsTable extends Migration {

	public function up()
	{
		Schema::create('readable_logs', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->morphs('related');
			$table->string('name_ar');
			$table->string('name_en')->nullable();
			$table->text('content_ar')->nullable();
			$table->text('content_en')->nullable();
			$table->nullableMorphs('causer');
		});
	}

	public function down()
	{
		Schema::drop('readable_logs');
	}
}