<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('id_company')->references('id')->on('Companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Robots', function(Blueprint $table) {
			$table->foreign('id_company')->references('id')->on('Companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('GroupUser', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('GroupUser', function(Blueprint $table) {
			$table->foreign('id_group')->references('id')->on('Groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Configurations', function(Blueprint $table) {
			$table->foreign('id_software')->references('id')->on('Softwares')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SystemRobot', function(Blueprint $table) {
			$table->foreign('id_robot')->references('id')->on('Robots')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SystemRobot', function(Blueprint $table) {
			$table->foreign('id_system')->references('id')->on('Systems')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('GroupSystem', function(Blueprint $table) {
			$table->foreign('id_system')->references('id')->on('Systems')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('GroupSystem', function(Blueprint $table) {
			$table->foreign('id_group')->references('id')->on('Groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Data', function(Blueprint $table) {
			$table->foreign('id_robot')->references('id')->on('Robots')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('RoleUser', function(Blueprint $table) {
			$table->foreign('id_role')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('RoleUser', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_id_company_foreign');
		});
		Schema::table('Robots', function(Blueprint $table) {
			$table->dropForeign('Robots_id_company_foreign');
		});
		Schema::table('GroupUser', function(Blueprint $table) {
			$table->dropForeign('GroupUser_id_user_foreign');
		});
		Schema::table('GroupUser', function(Blueprint $table) {
			$table->dropForeign('GroupUser_id_group_foreign');
		});
		Schema::table('Configurations', function(Blueprint $table) {
			$table->dropForeign('Configurations_id_software_foreign');
		});
		Schema::table('SystemRobot', function(Blueprint $table) {
			$table->dropForeign('SystemRobot_id_robot_foreign');
		});
		Schema::table('SystemRobot', function(Blueprint $table) {
			$table->dropForeign('SystemRobot_id_system_foreign');
		});
		Schema::table('GroupSystem', function(Blueprint $table) {
			$table->dropForeign('GroupSystem_id_system_foreign');
		});
		Schema::table('GroupSystem', function(Blueprint $table) {
			$table->dropForeign('GroupSystem_id_group_foreign');
		});
		Schema::table('Data', function(Blueprint $table) {
			$table->dropForeign('Data_id_robot_foreign');
		});
		Schema::table('RoleUser', function(Blueprint $table) {
			$table->dropForeign('RoleUser_id_role_foreign');
		});
		Schema::table('RoleUser', function(Blueprint $table) {
			$table->dropForeign('RoleUser_id_user_foreign');
		});
	}
}