<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('postal_country')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('delivery_country')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('companyid')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('categoryid')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('company_incoming')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('contact_incoming')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('company_outgoing')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('contact_outgoing')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('docs', function(Blueprint $table) {
			$table->foreign('parentdoc')->references('id')->on('docs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('docs', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('doclines', function(Blueprint $table) {
			$table->foreign('FK_product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('status')->references('id')->on('status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('emails', function(Blueprint $table) {
			$table->foreign('email_attachments')->references('id')->on('emailattachments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role', function(Blueprint $table) {
			$table->foreign('company')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role', function(Blueprint $table) {
			$table->foreign('contact')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_postal_country_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_delivery_country_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_companyid_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_categoryid_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_company_incoming_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_contact_incoming_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_company_outgoing_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_contact_outgoing_foreign');
		});
		Schema::table('docs', function(Blueprint $table) {
			$table->dropForeign('docs_parentdoc_foreign');
		});
		Schema::table('docs', function(Blueprint $table) {
			$table->dropForeign('docs_project_id_foreign');
		});
		Schema::table('doclines', function(Blueprint $table) {
			$table->dropForeign('doclines_FK_product_id_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_status_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_foreign');
		});
		Schema::table('emails', function(Blueprint $table) {
			$table->dropForeign('emails_email_attachments_foreign');
		});
		Schema::table('role', function(Blueprint $table) {
			$table->dropForeign('role_company_foreign');
		});
		Schema::table('role', function(Blueprint $table) {
			$table->dropForeign('role_contact_foreign');
		});
	}
}