<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDevicesTable extends Migration {

	public function up()
	{
		Schema::create('devices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title')->nullable();
			$table->string('supplier_name', 255)->nullable();
			$table->double('price')->nullable()->default('0');
			$table->integer('category_id')->unsigned();
			$table->integer('status')->default('0');
			$table->text('description')->nullable();
			$table->integer('provider_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('devices');
	}
}