<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('status')->nullable()->default('0');
			$table->integer('provider_id')->unsigned();
			$table->integer('plan_id')->unsigned();
			$table->double('price')->nullable();
			$table->integer('pay_type')->default('0');
			$table->integer('pay_status')->default('0');
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}