<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('maintance', 'market', 'rent'))->nullable();
			$table->enum('maintance_type', array('contract', 'immediate'))->nullable();
			$table->enum('price_policy', array('offers', 'admin'))->nullable();
			$table->string('device_name')->nullable();
			$table->integer('device_id')->unsigned();
			$table->integer('model_id')->unsigned();
			$table->integer('category_id')->unsigned()->nullable();
			$table->string('device_no', 255)->nullable();
			$table->text('lat')->nullable();
			$table->text('lng');
			$table->text('map_dsec')->nullable();
			$table->text('description');
			$table->integer('rent_period')->nullable()->default('0');
			$table->string('image')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('provider_id')->unsigned();
			$table->integer('status')->nullable()->default('0');
			$table->double('price')->nullable();
			$table->double('admin_commision')->nullable();
			$table->double('vat_amount')->nullable();
			$table->double('total_price')->nullable();
			$table->integer('pay_type')->default('0');
			$table->integer('pay_status')->nullable();
			$table->integer('contract_period')->nullable();
			$table->integer('device_count');
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->string('report')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}