<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('image', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('country_code', 255)->nullable();
			$table->string('phone', 255);
			$table->string('email', 255)->nullable();
			$table->integer('specialist_type')->nullable();
			$table->string('password', 255)->nullable();
			$table->string('identity_image', 255)->nullable();
			$table->string('licence_image', 255)->nullable();
			$table->string('work_certificate_image', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}