<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('request_id');
			$table->string('shipment_purpose');
			$table->date('required_date');
			$table->date('end_date');
			$table->string('request_type');
			$table->string('request_status');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('contact_id')->unsigned();
			$table->integer('end_user')->unsigned();
			$table->text('shipping_details');
			$table->text('request_details');
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}