<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('age');
			$table->bigInteger('blood_type_id')->unsigned();
			$table->decimal('longitude', 10.8);
			$table->decimal('latitude', 10.8);
			$table->bigInteger('city_id')->unsigned();
			$table->string('phone');
			$table->text('notes');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}