<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('country_key');
			$table->string('phone');
			$table->string('image', 255)->default('default.png');
			$table->timestamps();
			$table->softDeletes();
			$table->string('city_id');
			$table->string('code', 10);
			$table->string('identity_id');
			$table->string('identity_image', 255);
			$table->boolean('active')->default(0);
			$table->boolean('approve')->default(0);
			$table->text('experiences');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}