<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Memberships extends Model 
{

    protected $table = 'memberships';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('organization', 'start_at', 'still', 'expire_at', 'lawyer_id', 'name', 'country_id');

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

    public function country()
    {
        return $this->belongsTo('Countries', 'country_id');
    }

}