<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperiencesTable extends Migration {

	public function up()
	{
		Schema::create('experiences', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('start_at');
			$table->date('expire_at')->nullable();
			$table->boolean('still')->default(0);
			$table->string('company_name');
			$table->string('job_title');
			$table->string('company_location');
			$table->string('description')->nullable();
			$table->integer('lawyer_id');
		});
	}

	public function down()
	{
		Schema::drop('experiences');
	}
}