<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('address', 255);
			$table->enum('status', array('preparing', 'delivering'));
			$table->enum('payment_method', array('cash', 'mastercard', 'visa'));
			$table->smallInteger('preparing_time');
			$table->smallInteger('delivery_time');
			$table->double('delivery_cost', 8,2);
			$table->integer('delivery_man_id');
			$table->integer('client_id')->unsigned();
			$table->integer('restaurant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}