<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('email', 255);
			$table->string('number', 11);
			$table->string('password', 255);
			$table->integer('provider_id')->nullable();
			$table->decimal('longitude')->nullable();
			$table->decimal('latitude')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}