<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('image', 255);
			$table->string('address', 255);
			$table->string('phone', 11);
			$table->decimal('lang');
			$table->decimal('lat');
			$table->integer('rate');
			$table->enum('status', array('open', 'close'));
			$table->datetime('from');
			$table->datetime('to');
			$table->integer('category_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}