<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('address', 'status', 'payment_method', 'preparing_time', 'delivery_time', 'delivery_cost', 'delivery_man_id', 'client_id', 'restaurant_id');

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant');
	}

	public function products()
	{
		return $this->hasMany('App\Models\Product');
	}

}