<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_user')->unsigned();
			$table->timestamp('birth_date')->nullable();
			$table->string('first_name');
			$table->string('last_name')->nullable();
			$table->string('state')->nullable();
			$table->string('country')->nullable();
			$table->string('city')->nullable();
			$table->string('gender')->nullable();
			$table->string('address')->nullable();
			$table->string('avatar')->nullable();
			$table->text('description');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_details');
	}
}