<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDepartmentsTable extends Migration {

	public function up()
	{
		Schema::create('departments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('department_type_id')->unsigned()->index();
			$table->integer('facility_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('import_id', 64)->nullable();
			$table->string('source', 32)->nullable();
			$table->string('import_version', 15)->nullable();
			$table->enum('scope', array('FACILITY_WIDE', 'PLACE', 'ORG_UNIT'))->index();
			$table->string('meta_data')->nullable()->default('json');
			$table->string('client_department_name', 256)->nullable()->index();
			$table->string('client_patient_term', 60)->nullable()->index()->default('patient');
			$table->string('client_department_type_name', 256)->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('departments');
	}
}