<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    public function brand()
    {
        return $this->belongsTo('Brand');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function car()
    {
        return $this->belongsTo('Product');
    }

    public function product_image()
    {
        return $this->hasOne('ProductImage', 'product_id');
    }

}