<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoiceItems extends Model 
{

    protected $table = 'invoice_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'quantity', 'price', 'invoice_id', 'description');

    public function invoice()
    {
        return $this->belongsTo('Invoice', 'invoice_id');
    }

}