<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quotation extends Model 
{

    protected $table = 'quotation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'client_id', 'notes', 'price', 'total', 'expired_at');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function items()
    {
        return $this->hasMany('QuotationItems', 'quotation_id');
    }

}