<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StoreExit extends Model 
{

    protected $table = 'store_exit';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'client_id', 'source', 'type', 'goods_type', 'height', 'width', 'length', 'number', 'still_in', 'amount', 'area', 'note', 'chassis_number', 'car_type', 'price', 'cofactor_id', 'shipping_id', 'store_id', 'arrival_date');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function client()
    {
        return $this->belongsTo('Client', 'client_id');
    }

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function cofactor()
    {
        return $this->belongsTo('Cofactor', 'cofactor_id');
    }

    public function shipping()
    {
        return $this->belongsTo('Shipping', 'shipping_id');
    }

}