<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class QuotationItems extends Eloquent {

	protected $table = 'quotation_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'quantity', 'price', 'shipping_price', 'quotation_id', 'description');

	public function quotation()
	{
		return $this->belongsTo('Quotation', 'quotation_id');
	}

}