<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingClient extends Eloquent {

	protected $table = 'shipping_client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'shipping_id', 'client_id', 'total', 'total_after', 'total_contents', 'total_square', 'status', 'pay_status');

	public function shipping()
	{
		return $this->belongsTo('Shipping', 'shiping_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

	public function contents()
	{
		return $this->hasMany('ShippingContent', 'shipping_client_id');
	}

}