<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ShippingExpense extends Eloquent {

	protected $table = 'shipping_expense';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('shiping_id', 'amount', 'type_id', 'user_id', 'currency_id', 'details');

	public function shipping()
	{
		return $this->belongsTo('Shipping', 'shipping_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function currency()
	{
		return $this->belongsTo('Currency', 'currency_id');
	}

	public function type()
	{
		return $this->belongsTo('Type', 'type_id');
	}

}