<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Clinic extends Model 
{

    protected $table = 'Clinics';
    public $timestamps = true;

    public function advertisements()
    {
        return $this->hasMany('Advertisement');
    }

    public function clinic()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function specialty()
    {
        return $this->belongsTo('Specialty', 'specialty_id');
    }

    public function type_of_specialty()
    {
        return $this->belongsTo('Clinic', 'type_of_specialty_id');
    }

    public function doctors()
    {
        return $this->hasMany('Doctor');
    }

    public function discount()
    {
        return $this->morphOne('Discount');
    }

}