<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class District extends Model 
{

    protected $table = 'districts';
    public $timestamps = true;
    protected $fillable = array('name', 'city_id');

    public function restaurants()
    {
        return $this->hasMany('Restaurant');
    }

    public function clients()
    {
        return $this->hasMany('Client');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

}