<?php

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'state', 'minimum', 'image_restaurant', 'whats_app', 'phone_restaurant', 'delivery_fee', 'district_id');
	protected $hidden = array('password');

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function products()
	{
		return $this->hasMany('Product');
	}

	public function district()
	{
		return $this->belongsTo('District');
	}

	public function categories()
	{
		return $this->belongsToMany('\Category');
	}

	public function offers()
	{
		return $this->hasMany('Offer');
	}

	public function payment()
	{
		return $this->belongsTo('Payment');
	}

	public function orders()
	{
		return $this->hasMany('Order');
	}

	public function notifications()
	{
		return $this->morphMany('Notification', 'notifiable');
	}

	public function tokens()
	{
		return $this->morphMany('\Token', 'tokable');
	}

}