<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('poll_options', function(Blueprint $table) {
			$table->foreign('poll_id')->references('id')->on('polls')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_poll_answers', function(Blueprint $table) {
			$table->foreign('poll_answers_id')->references('id')->on('poll_options')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('poll_categories', function(Blueprint $table) {
			$table->foreign('poll_id')->references('id')->on('polls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poll_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('poll_options', function(Blueprint $table) {
			$table->dropForeign('poll_options_poll_id_foreign');
		});
		Schema::table('user_poll_answers', function(Blueprint $table) {
			$table->dropForeign('user_poll_answers_poll_answers_id_foreign');
		});
		Schema::table('poll_categories', function(Blueprint $table) {
			$table->dropForeign('poll_categories_poll_id_foreign');
		});
		Schema::table('poll_categories', function(Blueprint $table) {
			$table->dropForeign('poll_categories_category_id_foreign');
		});
	}
}