<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClassifiedDepartmentField extends Model 
{

    protected $table = 'classified_department_fields';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'type', 'placeholder', 'min', 'max', 'values', 'required', 'searched', 'classified_department_id');

    public function classifiedDepartment()
    {
        return $this->belongsTo('ClassifiedDepartment');
    }

}