<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Store extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;
    protected $fillable = array('name', 'details', 'image', 'phones', 'address', 'email', 'facebook', 'instagram', 'website', 'whats_up', 'store_category_id', 'province_id');

    public function storeCategory()
    {
        return $this->belongsTo('StoreCategory');
    }

    public function province()
    {
        return $this->belongsTo('Province');
    }

    public function products()
    {
        return $this->hasMany('Product');
    }

}