<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminTransfersToAffiliatesTable extends Migration {

	public function up()
	{
		Schema::create('admin_transfers_to_affiliates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('transfer_number');
			$table->date('transfer_date');
			$table->double('amount');
			$table->enum('received_by_affiliate', array('pending', 'received'));
			$table->bigInteger('affiliate_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('admin_transfers_to_affiliates');
	}
}