<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAffiliateClientsTable extends Migration {

	public function up()
	{
		Schema::create('affiliate_clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('mobile', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('total_price', 255)->default('0');
			$table->string('admin_percentage', 255)->default('0');
			$table->string('tax_percentage', 255)->default('0');
			$table->double('profit')->default('0');
			$table->enum('extra_tax_type', array('percent', 'number'))->nullable();
			$table->string('extra_tax_name', 255)->nullable();
			$table->double('extra_tax_value')->nullable();
			$table->enum('discount_type', array('percent', 'number'))->nullable();
			$table->string('discount_name', 255)->nullable();
			$table->double('discount_value')->nullable();
			$table->bigInteger('affiliate_transfer_to_admin_id')->unsigned()->nullable();
			$table->bigInteger('yellow_page_department_id')->unsigned()->nullable();
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('affiliate_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('affiliate_clients');
	}
}