<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255);
			$table->double('price');
			$table->text('description');
			$table->string('email', 255)->nullable();
			$table->string('facebook')->nullable();
			$table->text('location')->nullable();
			$table->json('mobiles')->nullable();
			$table->string('address')->nullable();
			$table->enum('status', array('enable', 'disable'));
			$table->json('images');
			$table->string('video')->nullable();
			$table->bigInteger('number_of_visitors')->unsigned()->default('0');
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('classified_department_id')->unsigned();
			$table->bigInteger('currency_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}